/*****************************************************************/
/*
/* Darts.r
/*
/* Copyright (c)
/* Apple computer, Inc. 1988-1990
/* All Rights Reserved
/*
/* Developer Technical Support Apple II Sample Code
/*
/* This file contains all definitions of resources used by
/* the darts program.
/*
/*****************************************************************/




/*---------------------------------------------------------------*/

#include "typesiigs.r"

/*------------------- Definitions -------------------*/


/* Window ID numbers */
#define RobinWindow $1000
#define CrickettWindow $1001

#define Player1ID 0
#define Player2ID $8000

/* Window position and size definitions. */
#define WinTop 30
#define WinLeft 10
#define WinHeight 165
#define WinWidth 620

/* Important positions inside the window */
#define Center WinWidth/2
#define Margin 4

/* Vertical position of the Line Edit fields */
#define TopofLE 2
#define BotOfLE 15

/* Score Size */
#define TopOfScore 20
#define BotOfScore 62
#define ScoreWidth 100

/* Vertical Positions of rows of buttons in Robin window */
#define TopRow1 70
#define BotRow1 83
#define TopRow2 90
#define BotRow2 103
#define TopRow3 110
#define BotRow3 123
#define TopRow4 140
#define BotRow4 153

/* Spacing of buttons in robin window */
#define DeltaX 30
#define ButWidth 24

#define Col1 LeftEdge1
#define Col2 LeftEdge1+1*DeltaX
#define Col3 LeftEdge1+2*DeltaX
#define Col4 LeftEdge1+3*DeltaX
#define Col5 LeftEdge1+4*DeltaX
#define Col6 LeftEdge1+5*DeltaX
#define Col7 LeftEdge1+6*DeltaX
#define Col8 LeftEdge1+7*DeltaX
#define Col9 LeftEdge1+8*DeltaX
#define Col10 LeftEdge1+9*DeltaX

/* Starting positions of items in Robin Window */
#define LeftEdge1 4
#define LeftEdge2 Center+LeftEdge1

#define ListWidth 150


/* Spacing of buttons in Crickett Window */
#define KButWidth 50
#define KButGap 50
#define VDelta (BotRow4-TopOfScore)/8
#define VGap 5

/* Vertical posisions of buttons in Cricktt Window */
#define TopRow20 TopOfScore
#define TopRow19 TopRow20+VDelta
#define TopRow18 TopRow19+VDelta
#define TopRow17 TopRow18+VDelta
#define TopRow16 TopRow17+VDelta
#define TopRow15 TopRow16+VDelta
#define TopRowBull TopRow15+VDelta


#define P2Name $100001
#define P1Name $100002

#define P1But01 1
#define P1But02 2
#define P1But03 3
#define P1But04 4
#define P1But05 5
#define P1But06 6
#define P1But07 7
#define P1But08 8
#define P1But09 9
#define P1But10 10
#define P1But11 11
#define P1But12 12
#define P1But13 13
#define P1But14 14
#define P1But15 15
#define P1But16 16
#define P1But17 17
#define P1But18 18
#define P1But19 19
#define P1But20 20
#define P1But25 25
#define P1ButBull 50

#define P2But01 1+$100
#define P2But02 2+$100
#define P2But03 3+$100
#define P2But04 4+$100
#define P2But05 5+$100
#define P2But06 6+$100
#define P2But07 7+$100
#define P2But08 8+$100
#define P2But09 9+$100
#define P2But10 10+$100
#define P2But11 11+$100
#define P2But12 12+$100
#define P2But13 13+$100
#define P2But14 14+$100
#define P2But15 15+$100
#define P2But16 16+$100
#define P2But17 17+$100
#define P2But18 18+$100
#define P2But19 19+$100
#define P2But20 20+$100
#define P2But25 25+$100
#define P2ButBull 50+$100

#define Player1List $30000
#define Player2List $40000

#define NewBut $20000
#define QuitBut $10000

#define P1Score $50000
#define P2Score $60000
#define P1ScoreText $50000
#define P2ScoreText $60000

#Define KValue $70000
#Define K1ScoreText $80000
#Define K2ScoreText $90000

#Define KPlayer1List $30001
#Define KPlayer2List $40001
#Define K1Score $50001
#Define K2Score $60001

#define K1But15 15+$200
#define K1But16 16+$200
#define K1But17 17+$200
#define K1But18 18+$200
#define K1But19 19+$200
#define K1But20 20+$200
#define K1ButBull 50+$200

#define K2But15 15+$300
#define K2But16 16+$300
#define K2But17 17+$300
#define K2But18 18+$300
#define K2But19 19+$300
#define K2But20 20+$300
#define K2ButBull 50+$300



#define Str1 1+$100
#define Str2 2+$100
#define Str3 3+$100
#define Str4 4+$100
#define Str5 5+$100
#define Str6 6+$100
#define Str7 7+$100
#define Str8 8+$100
#define Str9 9+$100
#define Str10 10+$100
#define Str11 11+$100
#define Str12 12+$100
#define Str13 13+$100
#define Str14 14+$100
#define Str15 15+$100
#define Str16 16+$100
#define Str17 17+$100
#define Str18 18+$100
#define Str19 19+$100
#define Str20 20+$100
#define Str25 25+$100
#define StrBull 50+$100
#define QuitStr 91+$100
#define NewStr 92+$100




/*----------------------- About Box ------------------------------*/
resource rAlertString (1) {
 "0\$19\$00\$A0\$00\$AA\$00\$E0\$01"
 "0/"
 TBCenterJust
 TBStyleOutline
 "Darts"
 TBEndOfLine
 TBStylePlain
 "A simple program to help us keep score. Originally written for Robin."
 TBEndOfLine
 TBEndOfLine
 "by"
 TBEndOfLine
 "Steven E. Glass"
 TBEndOfLine
 TBEndOfLine
 "Copyright 1988-1990"
 TBEndOfLine
 "Steven E. Glass and Apple Computer, Inc."
 TBEndOfLine
 "All Rights Reserved"
 TBEndOfLine
 "Version 3.0/^#6\$00"
};




/*----------------------- Confirm Box ------------------------------*/
resource rAlertString (2) {
 "42/Do you really want to quit?/^#3/#2"
 "\$00"
};


/*----------------------- Confirm Box ------------------------------*/
resource rAlertString (3) {
 "43/We have a winner!!!/^#6"
 "\$00"
};






/*----------------------Startup Record ---------------------------*/
resource rToolStartup (1) {
 mode640, /* master SCB */
 {
        3,$0300,  /* misc tools */
        4,$0301,  /* quickdraw */
        5,$0302,  /* desk manager */
        6,$0300,  /* eventMgr */
/*      7,$0200,  /* scheduler */
/*      8,$0301,  /* sound tools */
/*      9,$0201,  /* ADB tools */
/*      10,$0202, /* SANE */
        11,$0200, /* int math */
        14,$0301, /* Window Manager */
        15,$0301, /* Menu Manager */
        16,$0301, /* Control Manager */
        18,$0301, /* QD Aux */
/*      19,$0300, /* print manager */
        20,$0301, /* LineEdit tool set */
        21,$0302, /* Dialog Manager */
        22,$0300, /* Scrap manager */
/*      23,$0301, /* standard file */
/*      25,$0104, /* NoteSynth */
/*      26,$0104, /* Note Seq */
        27,$0301, /* Font manager */
        28,$0301, /* list manager */
/*      29,$0101, /* ACE */
/*      32,$0103, /* Midi Tools */
/*      34,$0101  /* text edit */
 }
};




/*---------------------------------------------------------------------------*/
/*
/* RobinWindow
/*
/* This is the template for the window that is used to score Robin's dart game.
/*
/*---------------------------------------------------------------------------*/
resource rWindParam1 (RobinWindow) {
 fTitle+fVis, /* Frame Bits */
 RobinWindow, /* title ID */
 0, /* ref Con */
 {0,0,0,0}, /* Zoom Rect */
 0, /* color table id */
 {0,0}, /* origin */
 {0,0}, /* data size */
 {0,0}, /* max height-width */
 {0,0}, /* scroll amount, hor,ver */
 {0,0}, /* page amount */
 0, /* wInfo Ref Con */
 0, /* wInfo height */
 {WinTop,WinLeft,WinTop+WinHeight,WinLeft+WinWidth}, /* window Position */
 infront, /* wPlane */
 RobinWindow, /* Control Ref */
 refIsResource*0x0100+ResourceToResource /* Verb */
};

/*---------------------------------------------------------------------------*/
/* This is the title of the Robin Window
/*---------------------------------------------------------------------------*/
resource rPString (RobinWindow) {
 "Robin Darts"
 };



/* List of all controls in Robin Window */

resource rControlList (RobinWindow) {
 {
 P2Name,
 P1Name,

 P1But01,
 P1But02,
 P1But03,
 P1But04,
 P1But05,
 P1But06,
 P1But07,
 P1But08,
 P1But09,
 P1But10,
 P1But11,
 P1But12,
 P1But13,
 P1But14,
 P1But15,
 P1But16,
 P1But17,
 P1But18,
 P1But19,
 P1But20,
 P1But25,
 P1ButBull,

 P2But01,
 P2But02,
 P2But03,
 P2But04,
 P2But05,
 P2But06,
 P2But07,
 P2But08,
 P2But09,
 P2But10,
 P2But11,
 P2But12,
 P2But13,
 P2But14,
 P2But15,
 P2But16,
 P2But17,
 P2But18,
 P2But19,
 P2But20,
 P2But25,
 P2ButBull,

 Player1List,
 Player2List,

 NewBut,
 QuitBut,

 P1Score,
 P2Score
 };
};








resource rControlTemplate (P1Name) {
 0, /* control ID */
 {TopOfLE,LeftEdge1,BotOfLE,Center-Margin}, /* control rectangle */
 EditLineControl{{ /* control type */
 0, /* Flag */
 fCtlProcNotPtr+RefIsResource, /* More Flags */
 0, /* ref con */
 40, /* Max Length */
 P1Name, /* Initial Value Ref */
 0 /* Text Length (ignored) */
 }};
};

resource rPString (P1Name) {
 "Player One"
 };


resource rControlTemplate (P2Name) {
 0, /* control ID */
 {TopOfLE,LeftEdge2,BotOfLE,WinWidth-Margin}, /* control rectangle */
 EditLineControl{{ /* control type */
 0, /* Flag */
 fCtlProcNotPtr+RefIsResource, /* More Flags */
 0, /* ref con */
 40, /* Max Length */
 P2Name, /* Initial Value Ref */
 0 /* Text Length (ignored) */
 }};
};


resource rPString (P2Name) {
 "Player Two"
 };


resource rControlTemplate (P1But01) {
 1+Player1ID, /* control ID */
 {TopRow1,Col1,BotRow1,Col1+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str1
 }};
};

resource rControlTemplate (P1But02) {
 2+Player1ID, /* control ID */
 {TopRow1,Col2,BotRow1,Col2+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str2
 }};
};

resource rControlTemplate (P1But03) {
 3+Player1ID, /* control ID */
 {TopRow1,Col3,BotRow1,Col3+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str3
 }};
};

resource rControlTemplate (P1But04) {
 4+Player1ID, /* control ID */
 {TopRow1,Col4,BotRow1,Col4+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str4
 }};
};

resource rControlTemplate (P1But05) {
 5+Player1ID, /* control ID */
 {TopRow1,Col5,BotRow1,Col5+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str5
 }};
};

resource rControlTemplate (P1But06) {
 6+Player1ID, /* control ID */
 {TopRow1,Col6,BotRow1,Col6+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str6
 }};
};

resource rControlTemplate (P1But07) {
 7+Player1ID, /* control ID */
 {TopRow1,Col7,BotRow1,Col7+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str7
 }};
};

resource rControlTemplate (P1But08) {
 8+Player1ID, /* control ID */
 {TopRow1,Col8,BotRow1,Col8+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str8
 }};
};

resource rControlTemplate (P1But09) {
 9+Player1ID, /* control ID */
 {TopRow1,Col9,BotRow1,Col9+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str9
 }};
};

resource rControlTemplate (P1But10) {
 10+Player1ID, /* control ID */
 {TopRow1,Col10,BotRow1,Col10+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str10
 }};
};

resource rControlTemplate (P1But11) {
 11+Player1ID, /* control ID */
 {TopRow2,Col1,BotRow2,Col1+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str11
 }};
};

resource rControlTemplate (P1But12) {
 12+Player1ID, /* control ID */
 {TopRow2,Col2,BotRow2,Col2+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str12
 }};
};

resource rControlTemplate (P1But13) {
 13+Player1ID, /* control ID */
 {TopRow2,Col3,BotRow2,Col3+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str13
 }};
};

resource rControlTemplate (P1But14) {
 14+Player1ID, /* control ID */
 {TopRow2,Col4,BotRow2,Col4+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str14
 }};
};

resource rControlTemplate (P1But15) {
 15+Player1ID, /* control ID */
 {TopRow2,Col5,BotRow2,Col5+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str15
 }};
};

resource rControlTemplate (P1But16) {
 16+Player1ID, /* control ID */
 {TopRow2,Col6,BotRow2,Col6+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str16
 }};
};

resource rControlTemplate (P1But17) {
 17+Player1ID, /* control ID */
 {TopRow2,Col7,BotRow2,Col7+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str17
 }};
};

resource rControlTemplate (P1But18) {
 18+Player1ID, /* control ID */
 {TopRow2,Col8,BotRow2,Col8+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str18
 }};
};

resource rControlTemplate (P1But19) {
 19+Player1ID, /* control ID */
 {TopRow2,Col9,BotRow2,Col9+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str19
 }};
};

resource rControlTemplate (P1But20) {
 20+Player1ID, /* control ID */
 {TopRow2,Col10,BotRow2,Col10+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str20
 }};
};

resource rControlTemplate (P1But25) {
 25+Player1ID, /* control ID */
 {TopRow3,Col1,BotRow3,Col5+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str25
 }};
};

resource rControlTemplate (P1ButBull) {
 50+Player1ID, /* control ID */
 {TopRow3,Col6,BotRow3,Col10+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 StrBull
 }};
};





resource rControlTemplate (P2But01) {
 1+Player2ID, /* control ID */
 {TopRow1,Center+Col1,BotRow1,Center+Col1+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str1
 }};
};

resource rControlTemplate (P2But02) {
 2+Player2ID, /* control ID */
 {TopRow1,Center+Col2,BotRow1,Center+Col2+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str2
 }};
};

resource rControlTemplate (P2But03) {
 3+Player2ID, /* control ID */
 {TopRow1,Center+Col3,BotRow1,Center+Col3+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str3
 }};
};

resource rControlTemplate (P2But04) {
 4+Player2ID, /* control ID */
 {TopRow1,Center+Col4,BotRow1,Center+Col4+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str4
 }};
};

resource rControlTemplate (P2But05) {
 5+Player2ID, /* control ID */
 {TopRow1,Center+Col5,BotRow1,Center+Col5+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str5
 }};
};

resource rControlTemplate (P2But06) {
 6+Player2ID, /* control ID */
 {TopRow1,Center+Col6,BotRow1,Center+Col6+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str6
 }};
};

resource rControlTemplate (P2But07) {
 7+Player2ID, /* control ID */
 {TopRow1,Center+Col7,BotRow1,Center+Col7+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str7
 }};
};

resource rControlTemplate (P2But08) {
 8+Player2ID, /* control ID */
 {TopRow1,Center+Col8,BotRow1,Center+Col8+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str8
 }};
};

resource rControlTemplate (P2But09) {
 9+Player2ID, /* control ID */
 {TopRow1,Center+Col9,BotRow1,Center+Col9+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str9
 }};
};

resource rControlTemplate (P2But10) {
 10+Player2ID, /* control ID */
 {TopRow1,Center+Col10,BotRow1,Center+Col10+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str10
 }};
};

resource rControlTemplate (P2But11) {
 11+Player2ID, /* control ID */
 {TopRow2,Center+Col1,BotRow2,Center+Col1+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str11
 }};
};

resource rControlTemplate (P2But12) {
 12+Player2ID, /* control ID */
 {TopRow2,Center+Col2,BotRow2,Center+Col2+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str12
 }};
};

resource rControlTemplate (P2But13) {
 13+Player2ID, /* control ID */
 {TopRow2,Center+Col3,BotRow2,Center+Col3+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str13
 }};
};

resource rControlTemplate (P2But14) {
 14+Player2ID, /* control ID */
 {TopRow2,Center+Col4,BotRow2,Center+Col4+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str14
 }};
};

resource rControlTemplate (P2But15) {
 15+Player2ID, /* control ID */
 {TopRow2,Center+Col5,BotRow2,Center+Col5+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str15
 }};
};

resource rControlTemplate (P2But16) {
 16+Player2ID, /* control ID */
 {TopRow2,Center+Col6,BotRow2,Center+Col6+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str16
 }};
};

resource rControlTemplate (P2But17) {
 17+Player2ID, /* control ID */
 {TopRow2,Center+Col7,BotRow2,Center+Col7+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str17
 }};
};

resource rControlTemplate (P2But18) {
 18+Player2ID, /* control ID */
 {TopRow2,Center+Col8,BotRow2,Center+Col8+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str18
 }};
};

resource rControlTemplate (P2But19) {
 19+Player2ID, /* control ID */
 {TopRow2,Center+Col9,BotRow2,Center+Col9+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str19
 }};
};

resource rControlTemplate (P2But20) {
 20+Player2ID, /* control ID */
 {TopRow2,Center+Col10,BotRow2,Center+Col10+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str20
 }};
};

resource rControlTemplate (P2But25) {
 25+Player2ID, /* control ID */
 {TopRow3,Center+Col1,BotRow3,Center+Col5+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 Str25
 }};
};

resource rControlTemplate (P2ButBull) {
 50+Player2ID, /* control ID */
 {TopRow3,Center+Col6,BotRow3,Center+Col10+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 StrBull
 }};
};


resource rControlTemplate (Player1List) {
 Player1List, /* Control ID */
 {TopOfScore,Center-Margin-ListWidth,BotOfScore,Center-Margin}, /* list rectangle */
 ListControl{{ /* list type */
 0, /* flag */
 fCtlProcNotPtr, /* more flags */
 0, /* ref con */
 0, /* Num Members in list */
 0, /* list view (let list mgr calc) */
 4, /* List type */
 1, /* list start (start at top ) */
 10, /* ListMemHeight */
 6, /* ListMemSize */
 0, /* ListRef (ID of list record) */
 0 /* color table ref (not used with pcount 14) */
 }};
};


resource rControlTemplate (Player2List) {
 Player2List, /* Control ID */
 {TopOfScore,WinWidth-Margin-ListWidth,BotOfScore,WinWidth-Margin}, /* list rectangle */
 ListControl{{ /* list type */
 0, /* flag */
 fCtlProcNotPtr, /* more flags */
 0, /* ref con */
 0, /* Num Members in list */
 0, /* list view (let list mgr calc) */
 4, /* List type */
 1, /* list start (start at top ) */
 10, /* ListMemHeight */
 6, /* ListMemSize */
 0, /* ListRef (ID of list record) */
 0 /* color table ref (not used with pcount 14) */
 }};
};


resource rControlTemplate (QuitBut) {
 QuitBut, /* control ID */
 {TopRow4,Center+Col1,BotRow4,Center+Col5+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 QuitStr
 }};
};


resource rControlTemplate (NewBut) {
 NewBut, /* control ID */
 {TopRow4,Col6,BotRow4,Col10+ButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 NewStr
 }};
};




resource rPString (Str1) {
 "1"
 };

resource rPString (Str2) {
 "2"
 };

resource rPString (Str3) {
 "3"
 };

resource rPString (Str4) {
 "4"
 };

resource rPString (Str5) {
 "5"
 };

resource rPString (Str6) {
 "6"
 };

resource rPString (Str7) {
 "7"
 };

resource rPString (Str8) {
 "8"
 };

resource rPString (Str9) {
 "9"
 };

resource rPString (Str10) {
 "10"
 };

resource rPString (Str11) {
 "11"
 };

resource rPString (Str12) {
 "12"
 };

resource rPString (Str13) {
 "13"
 };

resource rPString (Str14) {
 "14"
 };

resource rPString (Str15) {
 "15"
 };

resource rPString (Str16) {
 "16"
 };

resource rPString (Str17) {
 "17"
 };

resource rPString (Str18) {
 "18"
 };

resource rPString (Str19) {
 "19"
 };

resource rPString (Str20) {
 "20"
 };

resource rPString (Str25) {
 "25"
 };

resource rPString (StrBull) {
 "Bullseye"
 };

resource rPString (QuitStr) {
 "Quit"
 };

resource rPString (NewStr) {
 "New Game"
 };




resource rControlTemplate (P1Score) {
 P1Score, /* control ID */
 {TopOfScore,Margin,BotOfScore,Margin+ScoreWidth},
 StatTextControl{{ /* control type */
 0xFF03, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 P1ScoreText /* title ref */
 }};
};

/* The static text for list window */
resource rTextForLETextBox2 (P1ScoreText) {
 TBFont
 TBShaston
 "\$00\$20" /* plain, size 32 */
 "*0"
};


resource rControlTemplate (P2Score) {
 P2Score, /* control ID */
 {TopOfScore,Center+Margin,BotOfScore,Center+Margin+ScoreWidth},
 StatTextControl{{ /* control type */
 0xFF03, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 P2ScoreText /* title ref */
 }};
};

/* The static text for list window */
resource rTextForLETextBox2 (P2ScoreText) {
 TBFont
 TBShaston
 "\$00\$20" /* plain, size 32 */
 "*1"
};




/*---------------------------------------------------------------------------*/
/*
/* Crickett Window
/*
/* This is the template for the window that is used for a crickett game.
/*
/*---------------------------------------------------------------------------*/
resource rWindParam1 (CrickettWindow) {
 fTitle+fVis, /* Frame Bits */
 CrickettWindow, /* title ID */
 0, /* ref Con */
 {0,0,0,0}, /* Zoom Rect */
 0, /* color table id */
 {0,0}, /* origin */
 {0,0}, /* data size */
 {0,0}, /* max height-width */
 {0,0}, /* scroll amount, hor,ver */
 {0,0}, /* page amount */
 0, /* wInfo Ref Con */
 0, /* wInfo height */
 {WinTop,WinLeft,WinTop+WinHeight,WinLeft+WinWidth}, /* window Position */
 infront, /* wPlane */
 CrickettWindow, /* Control Ref */
 refIsResource*0x0100+ResourceToResource /* Verb */
};

/*---------------------------------------------------------------------------*/
/* This is the title of the Crickett Window
/*---------------------------------------------------------------------------*/
resource rPString (CrickettWindow) {
 "Crickett"
 };



/* List of all controls in Crickett Window */

resource rControlList (CrickettWindow) {
 {
 P2Name,
 P1Name,

 K1But15,
 K1But16,
 K1But17,
 K1But18,
 K1But19,
 K1But20,
 K1ButBull,

 K2But15,
 K2But16,
 K2But17,
 K2But18,
 K2But19,
 K2But20,
 K2ButBull,

 KPlayer1List,
 KPlayer2List,

 K1Score,
 K2Score,

 KValue,

 NewBut,
 QuitBut
 };
};









resource rControlTemplate (K1But15) {
 15+Player1ID, /* control ID */
 {TopRow15,Center-KButGap-KButWidth,TopRow15+VDelta-VGap,Center-KButGap}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr, /* more flags */
 0, /* ref con */
 0
 }};
};

resource rControlTemplate (K1But16) {
 16+Player1ID, /* control ID */
 {TopRow16,Center-KButGap-KButWidth,TopRow16+VDelta-VGap,Center-KButGap}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr, /* more flags */
 0, /* ref con */
 0
 }};
};

resource rControlTemplate (K1But17) {
 17+Player1ID, /* control ID */
 {TopRow17,Center-KButGap-KButWidth,TopRow17+VDelta-VGap,Center-KButGap}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr, /* more flags */
 0, /* ref con */
 0
 }};
};

resource rControlTemplate (K1But18) {
 18+Player1ID, /* control ID */
 {TopRow18,Center-KButGap-KButWidth,TopRow18+VDelta-VGap,Center-KButGap}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr, /* more flags */
 0, /* ref con */
 0
 }};
};

resource rControlTemplate (K1But19) {
 19+Player1ID, /* control ID */
 {TopRow19,Center-KButGap-KButWidth,TopRow19+VDelta-VGap,Center-KButGap}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr, /* more flags */
 0, /* ref con */
 0
 }};
};

resource rControlTemplate (K1But20) {
 20+Player1ID, /* control ID */
 {TopRow20,Center-KButGap-KButWidth,TopRow20+VDelta-VGap,Center-KButGap}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr, /* more flags */
 0, /* ref con */
 0
 }};
};


resource rControlTemplate (K1ButBull) {
 25+Player1ID, /* control ID */
 {TopRowBull,Center-KButGap-KButWidth,TopRowBull+VDelta-VGap,Center-KButGap}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr, /* more flags */
 0, /* ref con */
 0
 }};
};






resource rControlTemplate (K2But15) {
 15+Player2ID, /* control ID */
 {TopRow15,Center+KButGap,TopRow15+VDelta-VGap,Center+KButGap+KButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr, /* more flags */
 0, /* ref con */
 0
 }};
};

resource rControlTemplate (K2But16) {
 16+Player2ID, /* control ID */
 {TopRow16,Center+KButGap,TopRow16+VDelta-VGap,Center+KButGap+KButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr, /* more flags */
 0, /* ref con */
 0
 }};
};

resource rControlTemplate (K2But17) {
 17+Player2ID, /* control ID */
 {TopRow17,Center+KButGap,TopRow17+VDelta-VGap,Center+KButGap+KButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr, /* more flags */
 0, /* ref con */
 0
 }};
};

resource rControlTemplate (K2But18) {
 18+Player2ID, /* control ID */
 {TopRow18,Center+KButGap,TopRow18+VDelta-VGap,Center+KButGap+KButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr, /* more flags */
 0, /* ref con */
 0
 }};
};

resource rControlTemplate (K2But19) {
 19+Player2ID, /* control ID */
 {TopRow19,Center+KButGap,TopRow19+VDelta-VGap,Center+KButGap+KButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr, /* more flags */
 0, /* ref con */
 0
 }};
};

resource rControlTemplate (K2But20) {
 20+Player2ID, /* control ID */
 {TopRow20,Center+KButGap,TopRow20+VDelta-VGap,Center+KButGap+KButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr, /* more flags */
 0, /* ref con */
 0
 }};
};

resource rControlTemplate (K2ButBull) {
 25+Player2ID, /* control ID */
 {TopRowBull,Center+KButGap,TopRowBull+VDelta-VGap,Center+KButGap+KButWidth}, /* control rect */
 simpleButtonControl{{ /* control type */
 3, /* flag */
 fCtlProcNotPtr, /* more flags */
 0, /* ref con */
 0
 }};
};


resource rControlTemplate (KPlayer1List) {
 Player1List, /* Control ID */
 {TopRow17,Margin,TopRow17+BotOfScore-TopOfScore,Margin+ListWidth}, /* list rectangle */
 ListControl{{ /* list type */
 0, /* flag */
 fCtlProcNotPtr, /* more flags */
 0, /* ref con */
 0, /* Num Members in list */
 0, /* list view (let list mgr calc) */
 4, /* List type */
 1, /* list start (start at top ) */
 10, /* ListMemHeight */
 6, /* ListMemSize */
 0, /* ListRef (ID of list record) */
 0 /* color table ref (not used with pcount 14) */
 }};
};


resource rControlTemplate (KPlayer2List) {
 Player2List, /* Control ID */
 {TopRow17,WinWidth-Margin-ListWidth,TopRow17+BotOfScore-TopOfScore,WinWidth-Margin}, /* list rectangle */
 ListControl{{ /* list type */
 0, /* flag */
 fCtlProcNotPtr, /* more flags */
 0, /* ref con */
 0, /* Num Members in list */
 0, /* list view (let list mgr calc) */
 4, /* List type */
 1, /* list start (start at top ) */
 10, /* ListMemHeight */
 6, /* ListMemSize */
 0, /* ListRef (ID of list record) */
 0 /* color table ref (not used with pcount 14) */
 }};
};






resource rControlTemplate (K1Score) {
 P1Score, /* control ID */
 {TopOfScore,Margin,BotOfScore,Margin+ListWidth},
 StatTextControl{{ /* control type */
 0xFF03, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 k1ScoreText /* title ref */
 }};
};

/* The static text for list window */
resource rTextForLETextBox2 (k1ScoreText) {
 TBFont
 TBShaston
 "\$00\$20" /* plain, size 32 */
 "*0"
};


resource rControlTemplate (K2Score) {
 P2Score, /* control ID */
 {TopOfScore,WinWidth-Margin-ListWidth,BotOfScore,WinWidth-Margin},
 StatTextControl{{ /* control type */
 0xFF03, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 k2ScoreText /* title ref */
 }};
};

/* The static text for list window */
resource rTextForLETextBox2 (K2ScoreText) {
 TBRightJust
 TBFont
 TBShaston
 "\$00\$20" /* plain, size 32 */
 "*1"
};




resource rControlTemplate (KValue) {
 0, /* control ID */
 {TopRow20-6,Center-35,TopRowBull+VDelta,Center+35},
 StatTextControl{{ /* control type */
 CtlInactive, /* flag */
 fCtlProcNotPtr+RefIsResource, /* more flags */
 0, /* ref con */
 KValue /* title ref */
 }};
};

#Define Return "\$0D"

/* The static text for list window */
resource rTextForLETextBox2 (KValue) {
 TBCenterJust
 TBSpExtra
 "\$07\$00"
 "20"
 Return
 "19"
 Return
 "18"
 Return
 "17"
 Return
 "16"
 Return
 "15"
 Return
 "Bull"
 Return
};



/*********************************************************************/
/*
/* Menus
/*
/*********************************************************************/

#define AppleMenuID $1100
#define FileMenuID $1200
#define EditMenuID $1300
#define GameMenuID $1400

#Define AboutID $1101

#define CloseID 255
#define NewGameID $1202
#define QuitID $1203

#define UndoID 250
#define CutID 251
#define CopyID 252
#define PasteID 253
#define ClearID 254

#define RobinGameID $1401
#define CrickettGameID $1402


resource rMenuBar (1) {
 {
 AppleMenuID,
 FileMenuID,
 EditMenuID,
 GameMenuID
 };
};

resource rMenu (AppleMenuID) {
 AppleMenuID,
 RefIsResource*MenuTitleRefShift+RefIsResource*ItemRefShift+fAllowCache,
 AppleMenuID,
 { AboutID };
};

resource rMenu (FileMenuID) {
 FileMenuID,
 RefIsResource*MenuTitleRefShift+RefIsResource*ItemRefShift+fAllowCache,
 FileMenuID,
 { NewGameID,
 QuitID };
};

resource rMenu (EditMenuID) {
 EditMenuID,
 RefIsResource*MenuTitleRefShift+RefIsResource*ItemRefShift+fAllowCache,
 EditMenuID,
 {
 UndoID,
 CutID,
 CopyID,
 PasteID,
 ClearID
 };
 };

resource rMenu (GameMenuID) {
 GameMenuID,
 RefIsResource*MenuTitleRefShift+RefIsResource*ItemRefShift+fAllowCache,
 GameMenuID,
 { RobinGameID,CrickettGameID };
};

resource rMenuItem (AboutID) {
 AboutID,
 "","",
 0,
 RefIsResource*ItemTitleRefShift+fDivider,
 AboutID
};

resource rMenuItem (UndoID) {
 UndoID,
 "","",
 0,
 RefIsResource*ItemTitleRefShift,
 UndoID
};

resource rMenuItem (CutID) {
 CutID,
 "X","x",
 0,
 RefIsResource*ItemTitleRefShift,
 CutID
};

resource rMenuItem (CopyID) {
 CopyID,
 "C","c",
 0,
 RefIsResource*ItemTitleRefShift,
 CopyID
};

resource rMenuItem (PasteID) {
 PasteID,
 "V","v",
 0,
 RefIsResource*ItemTitleRefShift,
 PasteID
};

resource rMenuItem (ClearID) {
 ClearID,
 "","",
 0,
 RefIsResource*ItemTitleRefShift,
 ClearID
};

resource rMenuItem (CloseID) {
 CloseID,
 "W","w",
 0,
 RefIsResource*ItemTitleRefShift,
 CloseID
};

resource rMenuItem (QuitID) {
 QuitID,
 "Q","q",
 0,
 RefIsResource*ItemTitleRefShift,
 QuitID
};

resource rMenuItem (NewGameID) {
 NewGameID,
 "N","n",
 0,
 RefIsResource*ItemTitleRefShift,
 NewGameID
};

resource rMenuItem (RobinGameID) {
 RobinGameID,
 "","",
 0,
 RefIsResource*ItemTitleRefShift,
 RobinGameID
};

resource rMenuItem (CrickettGameID) {
 CrickettGameID,
 "","",
 0,
 RefIsResource*ItemTitleRefShift,
 CrickettGameID
};

resource rPString (AppleMenuID,noCrossBank) {
 "@"
 };
resource rPString (FileMenuID,noCrossBank) {
 " File "
 };
resource rPString (EditMenuID,noCrossBank) {
 " Edit "
 };
resource rPString (GameMenuID,noCrossBank) {
 " Game "
 };
resource rPString (AboutID,noCrossBank) {
 "About Darts..."
 };
resource rPString (UndoID,noCrossBank) {
 "Undo"
 };
resource rPString (CutID,noCrossBank) {
 "Cut"
 };
resource rPString (CopyID,noCrossBank) {
 "Copy"
 };
resource rPString (PasteID,noCrossBank) {
 "Paste"
 };
resource rPString (ClearID,noCrossBank) {
 "Clear"
 };
resource rPString (NewGameID,noCrossBank) {
 "New"
 };
resource rPString (QuitID,noCrossBank) {
 "Quit"
 };
resource rPString (RobinGameID,noCrossBank) {
 "Robin"
 };
resource rPString (CrickettGameID,noCrossBank) {
 "Crickett"
 };
